/*
 * Decompiled with CFR 0.152.
 */
package descry.internal;

import descry.VisualAlgorithm;
import descry.internal.FrameContext;
import descry.internal.Graphics;
import descry.internal.VisualDebugger;
import descry.internal.abstraction.Coroutine;
import descry.internal.abstraction.InterfaceBinding;
import descry.internal.processing.PAppletImpl;
import processing.core.PApplet;

public class Application {
    private final ScriptAdapter _script;

    public Application(VisualAlgorithm algorithm, int sizeX, int sizeY) {
        PAppletImpl.configure(this, sizeX, sizeY);
        this._script = new ScriptAdapter(algorithm);
    }

    public void launch() {
        PApplet.main(PAppletImpl.class, new String[0]);
    }

    public void initialize() {
        this._script.start();
    }

    public void renderFrame(Graphics g) {
        this._script.renderFrame(g);
    }

    private static class ScriptAdapter
    extends Coroutine
    implements FrameContext {
        private final InterfaceBinding _binding = new InterfaceBinding(FrameContext.class, Graphics.class, VisualDebugger.class);
        private final VisualAlgorithm _script;

        public ScriptAdapter(VisualAlgorithm script) {
            this._binding.setInvocationTarget(FrameContext.class, this);
            this._script = script;
        }

        public void renderFrame(Graphics g) {
            this._binding.setInvocationTarget(Graphics.class, g);
            this.update();
        }

        @Override
        public void setFrameRate(float x) {
            PAppletImpl.setFrameRate(x);
        }

        @Override
        public void beginFrame() {
            this.beginUpdate();
        }

        @Override
        public void endFrame() {
            this.endUpdate();
        }

        @Override
        protected void run() {
            VisualDebugger debugger = (VisualDebugger)this._binding.newProxyInstance();
            debugger.beginFrame();
            debugger.endFrame();
            this._script.run(debugger);
        }
    }
}

