/*
 * Decompiled with CFR 0.152.
 */
package descry.internal.abstraction;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;

public record Command(Method method, Object[] args) implements Serializable
{
    public Object invoke(Object target) throws Throwable {
        return this.method.invoke(target, this.args);
    }

    public static abstract class Dispatcher<T> {
        private final Class<T> _interfaceType;

        public Dispatcher(Class<T> interfaceType) {
            if (!interfaceType.isInterface()) {
                throw new RuntimeException();
            }
            this._interfaceType = interfaceType;
        }

        public abstract Object dispatch(Command var1, T var2);

        public T newProxyInstance(Supplier<T> target) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class[] interfaces = new Class[]{this._interfaceType};
            InvocationHandler handler = (proxy, method, args) -> this.dispatch(new Command(method, args), target.get());
            Object proxy2 = Proxy.newProxyInstance(classLoader, interfaces, handler);
            return this._interfaceType.cast(proxy2);
        }
    }
}

