/*
 * Decompiled with CFR 0.152.
 */
package descry.internal.abstraction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class InterfaceBinding
implements InvocationHandler {
    private final Set<Class<?>> _interfaces;
    private final HashMap<Class<?>, Supplier<?>> _suppliers;

    public InterfaceBinding(Class<?> ... interfaces) {
        this._interfaces = new HashSet(List.of(interfaces));
        this._suppliers = new HashMap();
    }

    public <T> void setInvocationTarget(Class<T> targetType, T target) {
        this.setInvocationTargetSupplier(targetType, () -> target);
    }

    public <T> void setInvocationTargetSupplier(Class<T> targetType, Supplier<T> target) {
        if (!this._interfaces.contains(targetType)) {
            return;
        }
        if (target == null) {
            this._suppliers.remove(targetType);
        } else {
            this._suppliers.put(targetType, target);
        }
    }

    public Object newProxyInstance() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        Class[] interfaces = this._interfaces.toArray(new Class[0]);
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        Class<?> source = method.getDeclaringClass();
        Supplier invocationTargetSupplier = this._suppliers.getOrDefault(source, null);
        if (invocationTargetSupplier == null) {
            return null;
        }
        return method.invoke(invocationTargetSupplier.get(), args);
    }
}

