/*
 * Decompiled with CFR 0.152.
 */
package algosrc;

import algosrc.Direction;
import algosrc.MazeGenerator;
import descry.Descry;
import descry.internal.VisualDebugger;
import java.util.LinkedList;
import java.util.Objects;

public class MazeSolver
extends MazeGenerator {
    Cell[][] grid;

    public MazeSolver(int sizeX, int sizeY) {
        super(sizeX, sizeY);
    }

    public void solve(VisualDebugger graphics, boolean[][][] maze, int startX, int startY, int endX, int endY) {
        Cell[][] cellArray = new Cell[this._gridSizeX][this._gridSizeY];
        for (int i = 0; i < this._gridSizeX; ++i) {
            for (int j = 0; j < this._gridSizeY; ++j) {
                boolean[] paths = new boolean[]{maze[i][j][0], maze[i][j][1], maze[i][j][2], maze[i][j][3]};
                cellArray[i][j] = new Cell(paths, new int[]{-1, -1}, false, false);
            }
        }
        this.renderFrame(graphics, cellArray);
        LinkedList<int[]> queue = new LinkedList<int[]>();
        queue.add(new int[]{startX, startY});
        while (!queue.isEmpty()) {
            this.renderFrame(graphics, cellArray);
            int[] current = (int[])queue.poll();
            int x = current[0];
            int y = current[1];
            if (x == endX && y == endY) {
                while (cellArray[x][y].lastCell[0] != -1) {
                    cellArray[x][y].inPath = true;
                    this.renderFrame(graphics, cellArray);
                    int nextX = cellArray[x][y].lastCell[0];
                    int nextY = cellArray[x][y].lastCell[1];
                    x = nextX;
                    y = nextY;
                }
                cellArray[startX][startY].inPath = true;
                this.renderFrame(graphics, cellArray);
                return;
            }
            cellArray[x][y].visited = true;
            for (Direction direction : Direction.values()) {
                boolean yInRange;
                if (!cellArray[x][y].paths[direction.ordinal()]) continue;
                int nextX = x + direction.X;
                int nextY = y + direction.Y;
                boolean xInRange = 0 <= nextX && nextX < this._gridSizeX;
                boolean bl = yInRange = 0 <= nextY && nextY < this._gridSizeY;
                if (!xInRange || !yInRange || cellArray[nextX][nextY].visited) continue;
                cellArray[nextX][nextY].lastCell[0] = x;
                cellArray[nextX][nextY].lastCell[1] = y;
                queue.add(new int[]{nextX, nextY});
            }
        }
    }

    private void renderFrame(VisualDebugger graphics, Cell[][] cellArray) {
        int y;
        int x;
        if (graphics == null) {
            return;
        }
        graphics.beginFrame();
        graphics.background(200);
        graphics.translate((float)graphics.getSizeX() * 0.5f - this._boardLocalCenterX, (float)graphics.getSizeY() * 0.5f - this._boardLocalCenterY);
        graphics.noStroke();
        for (x = 0; x < this._gridSizeX; ++x) {
            for (y = 0; y < this._gridSizeY; ++y) {
                if (cellArray[x][y].inPath) {
                    graphics.fillColor(227, 180, 39);
                } else if (cellArray[x][y].visited) {
                    graphics.fillColor(255);
                } else {
                    graphics.fillColor(220);
                }
                graphics.rectangle((float)x * this._cellSizeX, (float)y * this._cellSizeY, this._cellSizeX, this._cellSizeY);
            }
        }
        graphics.strokeColor(0);
        for (x = 0; x < this._gridSizeX; ++x) {
            for (y = 0; y < this._gridSizeY; ++y) {
                float cellCenterX = (float)x * this._cellSizeX + this._cellLocalCenterX;
                float cellCenterY = (float)y * this._cellSizeY + this._cellLocalCenterY;
                graphics.strokeWeight(3.0f);
                for (Direction direction : Direction.values()) {
                    if (cellArray[x][y].paths[direction.ordinal()]) continue;
                    if (direction.X != 0) {
                        graphics.line(cellCenterX + (float)direction.X * this._cellLocalCenterX, cellCenterY - this._cellLocalCenterY, cellCenterX + (float)direction.X * this._cellLocalCenterX, cellCenterY + this._cellLocalCenterY);
                    }
                    if (direction.Y == 0) continue;
                    graphics.line(cellCenterX - this._cellLocalCenterX, cellCenterY + (float)direction.Y * this._cellLocalCenterY, cellCenterX + this._cellLocalCenterX, cellCenterY + (float)direction.Y * this._cellLocalCenterY);
                }
            }
        }
        graphics.endFrame();
    }

    public static void main(String[] args) {
        Descry.visualize(new MazeSolver(18, 12));
    }

    @Override
    public void run(VisualDebugger graphics) {
        this.setBoardSize((float)graphics.getSizeX() * 0.8f, (float)graphics.getSizeY() * 0.8f);
        graphics.setFrameRate(20.0f);
        boolean[][][] maze = this.generatePaths(null);
        this.solve(graphics, maze, 0, 0, this._gridSizeX - 1, this._gridSizeY - 1);
    }

    static final class Cell {
        private final boolean[] paths;
        private int[] lastCell;
        private boolean visited;
        private boolean inPath;

        Cell(boolean[] paths, int[] lastCell, boolean visited, boolean inPath) {
            this.paths = paths;
            this.lastCell = lastCell;
            this.visited = visited;
        }

        public boolean[] paths() {
            return this.paths;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Cell that = (Cell)obj;
            return Objects.equals(this.paths, that.paths) && Objects.equals(this.lastCell, that.lastCell) && this.visited == that.visited;
        }

        public int hashCode() {
            return Objects.hash(this.paths, this.lastCell, this.visited);
        }

        public String toString() {
            return "Cell[paths=" + String.valueOf(this.paths) + ", lastCell=" + String.valueOf(this.lastCell) + ", visited=" + this.visited + "]";
        }
    }
}

