/*
 * Decompiled with CFR 0.152.
 */
package descry.internal.abstraction;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public abstract class Coroutine {
    private final Thread _thread = new Thread(this::run);
    private final CyclicBarrier _cycle = new CyclicBarrier(2);

    public final boolean isRunning() {
        return this._thread.isAlive();
    }

    public final void start() {
        if (this.isRunning()) {
            throw new RuntimeException("Coroutine is already running.");
        }
        this._thread.start();
    }

    public void update() {
        this.passBarrier();
        this.passBarrier();
    }

    private void passBarrier() {
        try {
            this._cycle.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void beginUpdate() {
        this.passBarrier();
    }

    protected final void endUpdate() {
        this.passBarrier();
    }

    protected abstract void run();
}

