/*
 * Decompiled with CFR 0.152.
 */
package algosrc;

import algosrc.Direction;
import descry.Descry;
import descry.VisualAlgorithm;
import descry.internal.VisualDebugger;
import descry.utility.Mathf;
import descry.utility.Random;
import java.util.Stack;

public class MazeGenerator
implements VisualAlgorithm {
    protected final int _gridSizeX;
    protected final int _gridSizeY;
    protected float _boardLocalCenterX;
    protected float _boardLocalCenterY;
    protected float _cellSizeX;
    protected float _cellSizeY;
    protected float _cellLocalCenterX;
    protected float _cellLocalCenterY;

    public static void main(String[] args) {
        Descry.visualize(new MazeGenerator(18, 12));
    }

    public MazeGenerator(int sizeX, int sizeY) {
        this._gridSizeX = sizeX;
        this._gridSizeY = sizeY;
    }

    public void setBoardSize(float boardSizeX, float boardSizeY) {
        this._boardLocalCenterX = boardSizeX * 0.5f;
        this._boardLocalCenterY = boardSizeY * 0.5f;
        this._cellSizeX = boardSizeX / (float)this._gridSizeX;
        this._cellSizeY = boardSizeY / (float)this._gridSizeY;
        this._cellLocalCenterX = this._cellSizeX * 0.5f;
        this._cellLocalCenterY = this._cellSizeY * 0.5f;
    }

    @Override
    public void run(VisualDebugger graphics) {
        this.setBoardSize((float)graphics.getSizeX() * 0.8f, (float)graphics.getSizeY() * 0.8f);
        this.generatePaths(graphics);
    }

    private void renderFrame(VisualDebugger graphics, boolean[][][] maze, boolean[][] visited, int i, int j, Stack<int[]> stack) {
        int y;
        int x;
        if (graphics == null) {
            return;
        }
        graphics.beginFrame();
        graphics.background(200);
        graphics.translate((float)graphics.getSizeX() * 0.5f - this._boardLocalCenterX, (float)graphics.getSizeY() * 0.5f - this._boardLocalCenterY);
        if (i < 0 || j < 0) {
            graphics.noStroke();
        } else {
            graphics.strokeWeight(1.0f);
            graphics.strokeColor(200);
        }
        for (x = 0; x < this._gridSizeX; ++x) {
            for (y = 0; y < this._gridSizeY; ++y) {
                if (x == i && y == j) {
                    graphics.fillColor(0, 255, 0);
                } else if (visited[x][y]) {
                    graphics.fillColor(255);
                } else {
                    graphics.fillColor(220);
                }
                graphics.rectangle((float)x * this._cellSizeX, (float)y * this._cellSizeY, this._cellSizeX, this._cellSizeY);
            }
        }
        for (x = 0; x < this._gridSizeX; ++x) {
            for (y = 0; y < this._gridSizeY; ++y) {
                if (x == i && y == j) {
                    graphics.fillColor(0, 255, 0);
                } else if (visited[x][y]) {
                    graphics.fillColor(255);
                } else {
                    graphics.fillColor(220);
                }
                graphics.rectangle((float)x * this._cellSizeX, (float)y * this._cellSizeY, this._cellSizeX, this._cellSizeY);
            }
        }
        graphics.fillColor(220, 220, 255);
        for (int p = 0; p < stack.size(); ++p) {
            int x2 = ((int[])stack.get(p))[0];
            int y2 = ((int[])stack.get(p))[1];
            graphics.rectangle((float)x2 * this._cellSizeX, (float)y2 * this._cellSizeY, this._cellSizeX, this._cellSizeY);
        }
        graphics.strokeColor(0);
        for (x = 0; x < this._gridSizeX; ++x) {
            for (y = 0; y < this._gridSizeY; ++y) {
                float cellCenterX = (float)x * this._cellSizeX + this._cellLocalCenterX;
                float cellCenterY = (float)y * this._cellSizeY + this._cellLocalCenterY;
                if (visited[x][y]) {
                    graphics.strokeWeight(3.0f);
                } else if (i >= 0 && j >= 0) {
                    graphics.strokeWeight(1.0f);
                }
                for (Direction direction : Direction.values()) {
                    if (maze[x][y][direction.ordinal()]) continue;
                    if (direction.X != 0) {
                        graphics.line(cellCenterX + (float)direction.X * this._cellLocalCenterX, cellCenterY - this._cellLocalCenterY, cellCenterX + (float)direction.X * this._cellLocalCenterX, cellCenterY + this._cellLocalCenterY);
                    }
                    if (direction.Y == 0) continue;
                    graphics.line(cellCenterX - this._cellLocalCenterX, cellCenterY + (float)direction.Y * this._cellLocalCenterY, cellCenterX + this._cellLocalCenterX, cellCenterY + (float)direction.Y * this._cellLocalCenterY);
                }
            }
        }
        graphics.endFrame();
    }

    public boolean[][][] generatePaths(VisualDebugger graphics) {
        Direction[] directions = Direction.values();
        boolean[][][] maze = new boolean[this._gridSizeX][this._gridSizeY][directions.length];
        boolean[][] visited = new boolean[this._gridSizeX][this._gridSizeY];
        int currentI = 0;
        int currentJ = 0;
        Stack<int[]> stack = new Stack<int[]>();
        stack.push(new int[]{currentI, currentJ});
        int stackCount = 1;
        while (stackCount > 0) {
            this.renderFrame(graphics, maze, visited, currentI, currentJ, stack);
            visited[currentI][currentJ] = true;
            int nextI = currentI;
            int nextJ = currentJ;
            int offset = Random.range(directions.length);
            for (int c = 0; c < directions.length; ++c) {
                int directionIndex = (c + offset) % directions.length;
                if (maze[currentI][currentJ][directionIndex]) continue;
                Direction direction = directions[directionIndex];
                nextI = currentI + direction.X;
                nextJ = currentJ + direction.Y;
                if (!Mathf.inRangeClosed(nextI, 0, this._gridSizeX - 1) || !Mathf.inRangeClosed(nextJ, 0, this._gridSizeY - 1)) {
                    nextI = currentI;
                    nextJ = currentJ;
                    continue;
                }
                if (visited[nextI][nextJ]) {
                    nextI = currentI;
                    nextJ = currentJ;
                    continue;
                }
                maze[currentI][currentJ][directionIndex] = true;
                switch (direction) {
                    case North: {
                        maze[nextI][nextJ][Direction.South.ordinal()] = true;
                        break;
                    }
                    case South: {
                        maze[nextI][nextJ][Direction.North.ordinal()] = true;
                        break;
                    }
                    case East: {
                        maze[nextI][nextJ][Direction.West.ordinal()] = true;
                        break;
                    }
                    case West: {
                        maze[nextI][nextJ][Direction.East.ordinal()] = true;
                    }
                }
                break;
            }
            if (nextI != currentI || nextJ != currentJ) {
                stack.push(new int[]{currentI, currentJ});
                ++stackCount;
                currentI = nextI;
                currentJ = nextJ;
                continue;
            }
            int[] current = stack.pop();
            currentI = current[0];
            currentJ = current[1];
            --stackCount;
        }
        maze[0][0][Direction.South.ordinal()] = true;
        maze[this._gridSizeX - 1][this._gridSizeY - 1][Direction.North.ordinal()] = true;
        this.renderFrame(graphics, maze, visited, -1, -1, stack);
        return maze;
    }
}

