/*
 * Decompiled with CFR 0.152.
 */
package algosrc;

import descry.Descry;
import descry.VisualAlgorithm;
import descry.internal.VisualDebugger;
import descry.utility.Log;
import descry.utility.Mathf;

public class Hanoi
implements VisualAlgorithm {
    private VisualDebugger _graphics;
    private final int _disks;
    private final Tower _pegA;
    private final Tower _pegB;
    private final Tower _pegC;

    public static void main(String[] args) {
        Descry.visualize(new Hanoi(8));
    }

    public Hanoi(int disks) {
        this._disks = disks;
        this._pegA = new Tower(this._disks, true);
        this._pegB = new Tower(this._disks, false);
        this._pegC = new Tower(this._disks, false);
    }

    @Override
    public void run(VisualDebugger graphics) {
        Log.info("Hanoi", "Script started.");
        this._graphics = graphics;
        this.drawTowers();
        this.hanoi(this._pegA, this._pegB, this._pegC, this._disks);
        Log.info("Hanoi", "Script ended.");
    }

    private void hanoi(Tower source, Tower target, Tower auxiliary, int n) {
        if (n > 0) {
            this.hanoi(source, auxiliary, target, n - 1);
            Tower.moveDisk(source, target);
            this.drawTowers();
            this.hanoi(auxiliary, target, source, n - 1);
        }
    }

    private void drawTowers() {
        float canvasCenterY = (float)this._graphics.getSizeY() * 0.5f;
        float canvasCenterX = (float)this._graphics.getSizeX() * 0.5f;
        float towerSizeY = (float)this._graphics.getSizeY() * 0.85f;
        float pegBaseY = canvasCenterY - towerSizeY * 0.5f;
        float diskHeight = towerSizeY / (float)this._disks;
        float pegSpacing = (float)this._graphics.getSizeX() / 3.0f * 0.75f;
        float pegAX = canvasCenterX - pegSpacing;
        float pegCX = canvasCenterX + pegSpacing;
        float diskMinSizeX = pegSpacing * 0.1f;
        float diskMaxSizeX = pegSpacing * 0.9f;
        this._graphics.beginFrame();
        this._graphics.rectangleMode(3);
        this._graphics.setFrameRate(8.0f);
        this._graphics.background(200);
        this._pegA.render(this._graphics, pegAX, pegBaseY, diskMinSizeX, diskMaxSizeX, diskHeight);
        this._pegB.render(this._graphics, canvasCenterX, pegBaseY, diskMinSizeX, diskMaxSizeX, diskHeight);
        this._pegC.render(this._graphics, pegCX, pegBaseY, diskMinSizeX, diskMaxSizeX, diskHeight);
        this._graphics.endFrame();
    }

    private static class Tower {
        private final int[] _disks;
        private final int _diskLimit;
        private int _diskOnPegCount;

        public Tower(int diskLimit, boolean isSource) {
            this._diskLimit = diskLimit;
            this._diskOnPegCount = isSource ? diskLimit : 0;
            this._disks = new int[diskLimit];
            if (isSource) {
                for (int d = 0; d < diskLimit; ++d) {
                    this._disks[d] = diskLimit - d;
                }
            }
        }

        public void render(VisualDebugger g, float baseX, float baseY, float diskMinSizeX, float diskMaxSizeX, float diskSizeY) {
            g.pushMatrix();
            g.translate(baseX, baseY);
            for (int d = 0; d < this._diskOnPegCount; ++d) {
                float diskSizeX = Mathf.map((float)this._disks[d], 0.0f, (float)this._diskLimit, diskMinSizeX, diskMaxSizeX);
                int rgb = (int)Mathf.map((float)this._disks[d], 0.0f, (float)this._diskLimit, 0.0f, 255.0f);
                g.fillColor(rgb, 100, 100, 255);
                g.rectangle(0.0f, (float)(this._diskLimit - d) * diskSizeY, diskSizeX, diskSizeY);
            }
            g.popMatrix();
        }

        public static void moveDisk(Tower source, Tower target) {
            int sourceTop = source._diskOnPegCount - 1;
            int targetTop = target._diskOnPegCount++;
            target._disks[targetTop] = source._disks[sourceTop];
            source._disks[sourceTop] = 0;
            --source._diskOnPegCount;
        }
    }
}

