/*
 * Decompiled with CFR 0.152.
 */
package algosrc;

import descry.Descry;
import descry.VisualAlgorithm;
import descry.internal.VisualDebugger;
import descry.utility.Mathf;
import descry.utility.Random;
import java.util.Arrays;

public class BinarySearch
implements VisualAlgorithm {
    private VisualDebugger _graphics;
    private final int[] _values = new int[24];
    private final Cell[] _cells = new Cell[24];
    private final Pointer _rangeMin = new Pointer();
    private final Pointer _rangeMax = new Pointer();
    private final Pointer _midPoint = new Pointer();
    private int _targetValue;

    public static void main(String[] args) {
        Descry.visualize(new BinarySearch());
    }

    @Override
    public void run(VisualDebugger graphics) {
        this._graphics = graphics;
        while (true) {
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = Random.range(this._values.length * 2);
            }
            Arrays.sort(this._values);
            this._targetValue = Random.choice(this._values);
            this.initializeRenderers();
            this.binarySearch(this._values, this._targetValue);
        }
    }

    private void initializeRenderers() {
        float boardSizeX = (float)this._graphics.getSizeX() * 0.8f;
        float boardSizeY = (float)this._graphics.getSizeY() * 0.2f;
        float boardLocalCenterX = boardSizeX * 0.5f;
        float boardLocalCenterY = boardSizeY * 0.5f;
        float boardGlobalCenterX = (float)this._graphics.getSizeX() * 0.5f;
        float boardGlobalCenterY = (float)this._graphics.getSizeY() * 0.5f;
        float rowLowerX = boardGlobalCenterX - boardLocalCenterX;
        float rowLowerY = boardGlobalCenterY - boardLocalCenterY;
        float cellSizeX = boardSizeX / (float)this._values.length;
        for (int i = 0; i < this._values.length; ++i) {
            float cellLowerX = rowLowerX + (float)i * cellSizeX;
            this._cells[i] = new Cell(i, this._values[i], cellLowerX, rowLowerY, cellSizeX, boardSizeY);
        }
    }

    private void update(int rangeMin, int rangeMax) {
        int midPoint = (rangeMin + rangeMax) / 2;
        Cell midPointCell = this._cells[midPoint];
        Cell rangeMinCell = this._cells[rangeMin];
        Cell rangeMaxCell = this._cells[rangeMax];
        this._midPoint.animateTo(midPoint, midPointCell.x + midPointCell.sizeX * 0.5f, midPointCell.y - 100.0f);
        this._rangeMin.animateTo(rangeMin, rangeMinCell.x + midPointCell.sizeX * 0.5f, rangeMinCell.y - 100.0f);
        this._rangeMax.animateTo(rangeMax, rangeMaxCell.x + midPointCell.sizeX * 0.5f, rangeMaxCell.y - 100.0f);
        this._rangeMin.update(1.0f);
        this._rangeMax.update(1.0f);
        float t = 0.0f;
        float tStep = 0.01f;
        while (t < 1.0f) {
            if ((t += tStep) > 1.0f) {
                t = 1.0f;
            }
            this._midPoint.update(t);
            this.renderFrame();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void renderFrame() {
        this._graphics.beginFrame();
        this._graphics.background(200);
        this._graphics.strokeColor(0);
        this._graphics.downArrow(this._midPoint.X, this._midPoint.Y + 30.0f, this._midPoint.X, this._midPoint.Y);
        this._graphics.downArrow(this._rangeMin.X, this._rangeMin.Y + 30.0f, this._rangeMin.X, this._rangeMin.Y);
        this._graphics.downArrow(this._rangeMax.X, this._rangeMax.Y + 30.0f, this._rangeMax.X, this._rangeMax.Y);
        for (int i = 0; i < this._cells.length; ++i) {
            Cell cell = this._cells[i];
            if (this._rangeMin.Index <= i && i <= this._rangeMax.Index) {
                this._graphics.fillColor(255);
            } else {
                this._graphics.fillColor(220);
            }
            this._graphics.rectangle(cell.x, cell.y, cell.sizeX, cell.sizeY);
            if (this._values[i] == this._targetValue) {
                this._graphics.fillColor(0, 255, 0);
            } else {
                this._graphics.fillColor(0);
            }
            float cellCenterX = cell.x + cell.sizeX * 0.5f;
            float cellCenterY = cell.y + cell.sizeY * 0.5f;
            this._graphics.textAlign(3, 3);
            this._graphics.textSize(20.0f);
            this._graphics.text(Integer.toString(this._values[i]), cellCenterX, cellCenterY);
        }
        this._graphics.endFrame();
    }

    private int binarySearch(int[] values, int target) {
        return this.binarySearch(values, target, 0, values.length - 1);
    }

    private int binarySearch(int[] values, int target, int low, int high) {
        this.update(low, high);
        if (high < low) {
            return -low;
        }
        int mid = (low + high) / 2;
        if (values[mid] > target) {
            return this.binarySearch(values, target, low, mid - 1);
        }
        if (values[mid] < target) {
            return this.binarySearch(values, target, mid + 1, high);
        }
        return mid;
    }

    private record Cell(int index, int value, float x, float y, float sizeX, float sizeY) {
    }

    private static final class Pointer {
        public int Index = -1;
        public float X;
        public float Y;
        private float _sourceX;
        private float _sourceY;
        private float _targetX;
        private float _targetY;

        private Pointer() {
        }

        public void update(float time01) {
            this.X = Mathf.lerp(this._sourceX, this._targetX, time01);
            this.Y = Mathf.lerp(this._sourceY, this._targetY, time01);
        }

        public void animateTo(int index, float targetX, float targetY) {
            this.Index = index;
            this._sourceX = this.X;
            this._sourceY = this.Y;
            this._targetX = targetX;
            this._targetY = targetY;
        }
    }
}

