/*
 * Decompiled with CFR 0.152.
 */
package algosrc;

import descry.Descry;
import descry.internal.VisualDebugger;
import java.util.Arrays;

public class InsertionSort {
    private static VisualDebugger graphics;
    private static final int[] arr;
    private static final int BGCOLOR = 100;

    public static void main(String[] args) {
        Descry.visualize(controller -> {
            graphics = controller;
            graphics.setFrameRate(1.0f);
            InsertionSort.run();
        });
    }

    private static void run() {
        InsertionSort.insertionSort(arr);
        System.out.println(Arrays.toString(arr));
    }

    private static void drawArray(int first, int compare) {
        graphics.beginFrame();
        graphics.background(100);
        graphics.strokeWeight(2.0f);
        graphics.strokeColor(0);
        float sizeX = (float)graphics.getSizeX() * 0.8f;
        float sizeY = (float)graphics.getSizeY() * 0.2f;
        float localCenterX = sizeX * 0.5f;
        float localCenterY = sizeY * 0.5f;
        float globalCenterX = (float)graphics.getSizeX() * 0.5f;
        float globalCenterY = (float)graphics.getSizeY() * 0.5f;
        float lowerX = globalCenterX - localCenterX;
        float lowerY = globalCenterY - localCenterY;
        graphics.rectangle(lowerX, lowerY, sizeX, sizeY);
        int cellCount = arr.length;
        float cellSizeX = sizeX / (float)cellCount;
        for (int i = 0; i < cellCount; ++i) {
            float cellLowerX = (float)i * cellSizeX + lowerX;
            float cellCenterX = cellLowerX + cellSizeX * 0.5f;
            float cellCenterY = lowerY + sizeY * 0.5f;
            graphics.fillColor(255);
            graphics.strokeColor(0);
            graphics.rectangle(cellLowerX, lowerY, cellSizeX, sizeY);
            if (i == first) {
                graphics.fillColor(255, 0, 0);
                graphics.strokeColor(255, 0, 0);
                graphics.downArrow(cellCenterX, cellCenterY - sizeY, cellCenterX, cellCenterY - sizeY - 30.0f);
            } else if (i == compare) {
                graphics.fillColor(0, 0, 255);
                graphics.strokeColor(0, 0, 255);
                graphics.downArrow(cellCenterX, cellCenterY - sizeY, cellCenterX, cellCenterY - sizeY - 30.0f);
            } else {
                graphics.fillColor(0);
            }
            graphics.textSize(20.0f);
            graphics.textAlign(3, 3);
            graphics.text(Integer.toString(arr[i]), cellCenterX, cellCenterY);
        }
        graphics.endFrame();
    }

    private static void drawArray(int valueHighlight) {
        graphics.beginFrame();
        graphics.background(100);
        float sizeX = (float)graphics.getSizeX() * 0.8f;
        float sizeY = (float)graphics.getSizeY() * 0.2f;
        float localCenterX = sizeX * 0.5f;
        float localCenterY = sizeY * 0.5f;
        float globalCenterX = (float)graphics.getSizeX() * 0.5f;
        float globalCenterY = (float)graphics.getSizeY() * 0.5f;
        float lowerX = globalCenterX - localCenterX;
        float lowerY = globalCenterY - localCenterY;
        graphics.rectangle(lowerX, lowerY, sizeX, sizeY);
        int cellCount = arr.length;
        float cellSizeX = sizeX / (float)cellCount;
        for (int i = 0; i < cellCount; ++i) {
            float cellLowerX = (float)i * cellSizeX + lowerX;
            float cellCenterX = cellLowerX + cellSizeX * 0.5f;
            float cellCenterY = lowerY + sizeY * 0.5f;
            graphics.fillColor(255);
            graphics.rectangle(cellLowerX, lowerY, cellSizeX, sizeY);
            if (arr[i] == valueHighlight) {
                graphics.fillColor(255, 0, 0);
            } else {
                graphics.fillColor(0);
            }
            graphics.textSize(20.0f);
            graphics.text(Integer.toString(arr[i]), cellCenterX, cellCenterY);
        }
        graphics.endFrame();
    }

    private static void drawArray() {
        graphics.beginFrame();
        graphics.background(100);
        float sizeX = (float)graphics.getSizeX() * 0.8f;
        float sizeY = (float)graphics.getSizeY() * 0.2f;
        float localCenterX = sizeX * 0.5f;
        float localCenterY = sizeY * 0.5f;
        float globalCenterX = (float)graphics.getSizeX() * 0.5f;
        float globalCenterY = (float)graphics.getSizeY() * 0.5f;
        float lowerX = globalCenterX - localCenterX;
        float lowerY = globalCenterY - localCenterY;
        graphics.rectangle(lowerX, lowerY, sizeX, sizeY);
        int cellCount = arr.length;
        float cellSizeX = sizeX / (float)cellCount;
        for (int i = 0; i < cellCount; ++i) {
            float cellLowerX = (float)i * cellSizeX + lowerX;
            float cellCenterX = cellLowerX + cellSizeX * 0.5f;
            float cellCenterY = lowerY + sizeY * 0.5f;
            graphics.fillColor(255);
            graphics.rectangle(cellLowerX, lowerY, cellSizeX, sizeY);
            graphics.fillColor(0);
            graphics.textSize(20.0f);
            graphics.text(Integer.toString(arr[i]), cellCenterX, cellCenterY);
        }
        graphics.endFrame();
    }

    public static void insertionSort(int[] A) {
        for (int i = 1; i < A.length; ++i) {
            InsertionSort.drawArray(A[i]);
            int value = A[i];
            for (int j = i - 1; j >= 0 && A[j] > value; --j) {
                InsertionSort.drawArray(i, j);
                A[j + 1] = A[j];
            }
            A[j + 1] = value;
            InsertionSort.drawArray(A[i]);
        }
        InsertionSort.drawArray();
    }

    static {
        arr = new int[]{3, 2, 6, 1, 5, 4, 16, 7, 11, 12, 19, 10};
    }
}

