/*
 * Decompiled with CFR 0.152.
 */
package descry.utility;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;

public class Log {
    private static int _logLevel = 3;
    private static Logger _logger = new Logger();
    public static boolean ERROR = _logLevel <= 5;
    public static boolean WARN = _logLevel <= 4;
    public static boolean INFO = _logLevel <= 3;
    public static boolean DEBUG = _logLevel <= 2;
    public static boolean TRACE = _logLevel <= 1;

    private Log() {
    }

    public static void setLogLevel(int level) {
        _logLevel = level;
        ERROR = level <= 5;
        WARN = level <= 4;
        INFO = level <= 3;
        DEBUG = level <= 2;
        TRACE = level <= 1;
    }

    public static int getLogLevel() {
        return _logLevel;
    }

    public static void setLogger(Logger logger) {
        _logger = logger;
    }

    public static void error(String message, Throwable ex) {
        if (ERROR) {
            _logger.log(5, null, message, ex);
        }
    }

    public static void error(String category, String message, Throwable ex) {
        if (ERROR) {
            _logger.log(5, category, message, ex);
        }
    }

    public static void error(String message) {
        if (ERROR) {
            _logger.log(5, null, message, null);
        }
    }

    public static void error(String category, String message) {
        if (ERROR) {
            _logger.log(5, category, message, null);
        }
    }

    public static void warn(String message, Throwable ex) {
        if (WARN) {
            _logger.log(4, null, message, ex);
        }
    }

    public static void warn(String category, String message, Throwable ex) {
        if (WARN) {
            _logger.log(4, category, message, ex);
        }
    }

    public static void warn(String message) {
        if (WARN) {
            _logger.log(4, null, message, null);
        }
    }

    public static void warn(String category, String message) {
        if (WARN) {
            _logger.log(4, category, message, null);
        }
    }

    public static void info(String message, Throwable ex) {
        if (INFO) {
            _logger.log(3, null, message, ex);
        }
    }

    public static void info(String category, String message, Throwable ex) {
        if (INFO) {
            _logger.log(3, category, message, ex);
        }
    }

    public static void info(String message) {
        if (INFO) {
            _logger.log(3, null, message, null);
        }
    }

    public static void info(String category, String message) {
        if (INFO) {
            _logger.log(3, category, message, null);
        }
    }

    public static void debug(String message, Throwable ex) {
        if (DEBUG) {
            _logger.log(2, null, message, ex);
        }
    }

    public static void debug(String category, String message, Throwable ex) {
        if (DEBUG) {
            _logger.log(2, category, message, ex);
        }
    }

    public static void debug(String message) {
        if (DEBUG) {
            _logger.log(2, null, message, null);
        }
    }

    public static void debug(String category, String message) {
        if (DEBUG) {
            _logger.log(2, category, message, null);
        }
    }

    public static void trace(String message, Throwable ex) {
        if (TRACE) {
            _logger.log(1, null, message, ex);
        }
    }

    public static void trace(String category, String message, Throwable ex) {
        if (TRACE) {
            _logger.log(1, category, message, ex);
        }
    }

    public static void trace(String message) {
        if (TRACE) {
            _logger.log(1, null, message, null);
        }
    }

    public static void trace(String category, String message) {
        if (TRACE) {
            _logger.log(1, category, message, null);
        }
    }

    public static class LogLevel {
        public static final int None = 6;
        public static final int Error = 5;
        public static final int Warn = 4;
        public static final int Info = 3;
        public static final int Debug = 2;
        public static final int Trace = 1;

        public static String toName(int level) {
            return switch (level) {
                case 5 -> "ERROR";
                case 4 -> " WARN";
                case 3 -> " INFO";
                case 2 -> "DEBUG";
                case 1 -> "TRACE";
                default -> "";
            };
        }
    }

    public static class Logger {
        private final long _firstLogTime = System.currentTimeMillis();

        public void log(int level, String category, String message, Throwable ex) {
            StringBuilder builder = new StringBuilder(256);
            long time = System.currentTimeMillis() - this._firstLogTime;
            long minutes = TimeUnit.MILLISECONDS.toMinutes(time);
            long seconds = TimeUnit.MILLISECONDS.toSeconds(time);
            if (minutes <= 9L) {
                builder.append('0');
            }
            builder.append(minutes);
            builder.append(':');
            if (seconds <= 9L) {
                builder.append('0');
            }
            builder.append(seconds);
            builder.append(" ");
            builder.append(LogLevel.toName(level));
            builder.append(": ");
            if (category != null) {
                builder.append("[");
                builder.append(category);
                builder.append("] ");
            }
            builder.append(message);
            if (ex != null) {
                StringWriter writer = new StringWriter(256);
                ex.printStackTrace(new PrintWriter(writer));
                builder.append('\n');
                builder.append(writer.toString().trim());
            }
            System.out.println(builder.toString());
        }
    }
}

